/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.item;

import com.chefmooon.ubesdelight.common.Configuration;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class UbesDelightBlockItem
extends BlockItem {
    protected final boolean hasFoodEffectTooltip;
    protected final boolean hasCustomTooltip;
    private final int burnTime;

    public UbesDelightBlockItem(Block block, Item.Properties properties) {
        this(block, properties, false, false, 0);
    }

    public UbesDelightBlockItem(Block block, Item.Properties properties, boolean hasFoodEffectTooltip) {
        this(block, properties, hasFoodEffectTooltip, false, 0);
    }

    public UbesDelightBlockItem(Block block, Item.Properties properties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip) {
        this(block, properties, hasFoodEffectTooltip, hasCustomTooltip, 0);
    }

    public UbesDelightBlockItem(Block block, Item.Properties properties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip, int burnTime) {
        super(block, properties);
        this.hasCustomTooltip = hasCustomTooltip;
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.burnTime = burnTime;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (Configuration.isFoodEffectTooltip()) {
            if (this.hasCustomTooltip) {
                tooltip.add((Component)TextUtils.getTranslatable("tooltip." + this, new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip(stack, tooltip, 1.0f);
            }
        }
    }
}

